<?php
// Display and update user profile
session_start();
include('../includes/config.php');
$user_id = $_SESSION['user_id'];  // Assume user is logged in

// Fetch user data
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

// Display profile data
echo '<h1>' . htmlspecialchars($user['username']) . '\'s Profile</h1>';
echo '<p>Bio: ' . htmlspecialchars($user['bio']) . '</p>';
echo '<p>Sexuality: ' . htmlspecialchars($user['sexuality']) . '</p>';
echo '<img src="../uploads/' . $user['profile_picture'] . '" alt="Profile Picture">';

// Update form (if needed)
echo '<form method="POST" enctype="multipart/form-data">
    Update Bio: <textarea name="bio">' . htmlspecialchars($user['bio']) . '</textarea><br>
    Update Profile Picture: <input type="file" name="profile_picture"><br>
    <input type="submit" value="Update">
</form>';
?>
