<?php
// Ratchet WebSocket server setup
require 'vendor/autoload.php';
use Ratchet\MessageComponentInterface;
use Ratchet\ConnectionInterface;

class ChatServer implements MessageComponentInterface {
    public function onOpen(ConnectionInterface $conn) {
        echo "New connection! ({$conn->resourceId})\n";
    }
    public function onClose(ConnectionInterface $conn) {
        echo "Connection closed! ({$conn->resourceId})\n";
    }
    public function onMessage(ConnectionInterface $from, $msg) {
        echo "Message received: $msg\n";
        foreach ($from->httpRequest->getHeader('Sec-WebSocket-Protocol') as $client) {
            $client->send($msg);
        }
    }
    public function onError(ConnectionInterface $conn, \Exception $e) {
        echo "Error: {$e->getMessage()}\n";
        $conn->close();
    }
}

$server = new Ratchet\App("localhost", 8080);
$server->route("/chat", new ChatServer, array('*'));
$server->run();
?>
